import { z } from "zod";
import { tryLoadEnv } from "./try-load-env";

tryLoadEnv()

const envVariables = z.object({
  BACKEND_AWS_COGNITO_RESOURCE_NAME_PREFIX: z.preprocess((a) => typeof a === "string" && !!a ? a : "local", z.string()),
  BACKEND_AWS_COGNITO_ADMIN_GROUP_NAME: z.string(),
  BACKEND_AWS_COGNITO_VIEWER_GROUP_NAME: z.string(),
  BACKEND_AWS_S3_BUCKET_REGION: z.string(),
  BACKEND_AWS_S3_BUCKET_NAME: z.string(),
  BACKEND_AWS_S3_POLICY_ARN: z.string(),
  BACKEND_AWS_STEP_FUNCTION_ARN: z.string(),
  BACKEND_AWS_PUBLISH_CHANGES_STEP_FUNCTION_ARN: z.string(),

  BACKEND_REST_API_ALLOWED_ORIGIN: z.string(),
  BACKEND_REST_API_ALLOWED_METHODS: z.string(),
  BACKEND_REST_API_ALLOWED_HEADERS: z.string(),

  BACKEND_STATEWIDE_SERVICES_DYNAMODB_TABLENAME: z.string(),
  BACKEND_USER_METADATA_DYNAMODB_TABLENAME: z.string(),

  CDK_CONTEXT_JSON: z.string(),
});

export const env = envVariables.parse(process.env);

export type EnvVariables = z.infer<typeof envVariables>
